/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.content;


import com.adobe.xfa.Arg;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ProtoableNodeScript;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptTable;


/**
 * This class contains all the script functionality associated with the
 * Content class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class ContentScript extends ProtoableNodeScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ProtoableNodeScript.moScriptTable,
		"content",
		new ScriptPropObj[] {
			new ScriptPropObj(ContentScript.class, "isNull", "getIsNull", "setIsNull", Arg.BOOL, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_ISNULL_DESC,XFA_IS_ISNULL_RET*/, 0)
		},
		null
	);

	public static void getClassName(Obj pThis, Arg oRetVal) {
		oRetVal.setString(pThis.getClassAtom());
	}
	
	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getIsNull(Obj pObj, Arg oRetVal) {
		oRetVal.setBool(Boolean.valueOf(((Content) pObj).getIsNull()));
	}

	public static void setIsNull(Obj pObj, Arg oArg) {
		((Content) pObj).setIsNull(oArg.getBool().booleanValue(), true, false);
	}

}
