/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;

/**
 * The FAILURE macro is essentially like an assert.  It does not
 * return control to the caller (it throws an exception).  In
 * debug mode, it provides some useful information, including
 * an English message intended for developers to see.  In release
 * mode, a generic "Software Failure" exception is thrown.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class SWFailure {

	public static void fail(String sEnglishMessage) {
		throw new ExFull(ResId.SOFTWARE_FAILURE, sEnglishMessage);
	}
}
