/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.workflow.api;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.wcm.api.Page;
import com.day.cq.workflow.model.WorkflowModel;
import com.day.cq.workflow.exec.Workflow;

/**
 * The <code>WcmWorkflowService</code> interface defines (util) methods that are
 * used in the WCM system in cunjunction with the workflow engine.
 */
public interface WcmWorkflowService {

    /**
     * Request for de/activation event topic
     */
    public static final String EVENT_TOPIC = "com/day/cq/wcm/workflow/req/for/activation";

    /**
     * Checks wether a <code>{@link Page}</code> is subject of a running <code>
     * {@link com.day.cq.workflow.exec.Workflow} instance</code>.
     *
     * @param pagePath path of <code>{@link Page}</code> to check
     * @return <code>true</code> if <code>{@link Page}</code> is subject of a
     * running workflow
     */
    boolean isInWorkflow(String pagePath);

    /**
     * Returns the preconfigured <code>{@link com.day.cq.workflow.model.WorkflowModel}</code>
     * for the desired <code>{@link ReplicationActionType}</code>. This is used
     * in case a user has no replication previlidges.
     *
     * @param replicationType replication type
     * @return preconfigured <code>WorkflowModel</code>
     */
    WorkflowModel getRequestForReplicationWorkflowModel(
            ReplicationActionType replicationType);

    /**
     * The <code>{@link com.day.cq.workflow.exec.Workflow} instance </code> is
     * returned.
     *
     * @param pagePath page path
     * @return the <code>{@link com.day.cq.workflow.exec.Workflow} instance </code>
     * or <code>null</code> if not existing.
     */
    Workflow getWorkflowInstance(String pagePath);

    /**
     * Specifies the location where the wcm workflow specifx stuff is stored in
     * repository
     * @return path
     */
    String getWcmConfigPath();
}
