/*
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package com.day.util.diff;

/**
 * Provides a default document source
 */
public class DefaultDocumentSource implements DocumentSource {

    /**
     * some location information
     */
    private final String location;

    /**
     * the author
     */
    private final String author;

    /**
     * the date
     */
    private final long date;

    /**
     * the revision
     */
    private final String revision;

    /**
     * Creates a new default document source
     *
     * @param location some location information
     * @param author the author of the document
     * @param date some date of the document
     * @param revision some revision of the document
     */
    public DefaultDocumentSource(String location, String author, long date, String revision) {
        this.location = location;
        this.author = author;
        this.date = date;
        this.revision = revision;
    }

    /**
     * {@inheritDoc}
     */
    public String getLocation() {
        return location;
    }

    /**
     * Returns the revision information.
     *
     * {@inheritDoc}
     */
    public String getLabel() {
        return revision;
    }

    /**
     * Returns the author
     * @return the author
     */
    public String getAuthor() {
        return author;
    }

    /**
     * Returns the date
     * @return the date
     */
    public long getDate() {
        return date;
    }

    /**
     * Returns the revision
     * @return the revision
     */
    public String getRevision() {
        return revision;
    }


    public String toString() {
        return author + ", " + revision;
    }
}
