/**
 * 
 */
package com.adobe.internal.mac.resource;

/**
 * This is for internal use of the Mac resource parser code only.  It needs much cleanup before
 * it is made public.
 *
 */
final class ScriptUtility 
{
	private static final String[][] SCRIPTID_TO_ENCODING =
	{
		new String[] {"MacRoman"},			//smRoman	0	Roman
		new String[] {"macjapanese"},		//smJapanese	1	Japanese
		new String[] {"MacChineseTraditional"},	//smTradChinese	2	Traditional Chinese
		new String[] {"MacKorean"},			//smKorean	3	Korean
		new String[] {"MacArabic"},			//smArabic	4	Arabic
		new String[] {"MacHebrew"},			//smHebrew	5	Hebrew
		new String[] {"MacGreek"},			//smGreek	6	Greek
		new String[] {"MacCyrillic"},		//smCyrillic	7	Cyrillic
		new String[] {"MacSymbol"},			//smRSymbol	8	Right-to-left symbols
		new String[] {"MacDevanagari"},		//smDevanagari	9	Devanagari
		new String[] {"MacGurmukhi"},		//smGurmukhi	10	Gurmukhi
		new String[] {"MacGujarati"},		//smGujarati	11	Gujarati
		new String[] {},					//smOriya	12	Oriya
		new String[] {},					//smBengali	13	Bengali
		new String[] {},					//smTamil	14	Tamil
		new String[] {},					//smTelugu	15	Telugu
		new String[] {},					//smKannada	16	Kannada/Kanarese
		new String[] {},					//smMalayalam	17	Malayalam
		new String[] {},					//smSinhalese	18	Sinhalese
		new String[] {},					//smBurmese	19	Burmese
		new String[] {},					//smKhmer	20	Khmer
		new String[] {"MacThai"},			//smThai	21	Thai
		new String[] {},					//smLaotian	22	Laotian
		new String[] {},					//smGeorgian	23	Georgian
		new String[] {},					//smArmenian	24	Armenian
		new String[] {"MacChineseSimplified"},	//smSimpChinese	25	Simplified Chinese
		new String[] {},					//smTibetan	26	Tibetan
		new String[] {},					//smMongolian	27	Mongolian
		new String[] {},					//smEthiopic	28	= smGeez  and  smGeez	28	Geez/Ethiopic
		new String[] {"MacCentralEuropean"},//smEastEurRoman	29	Extended Roman for Slavic and Baltic languages
		new String[] {},					//smVietnamese	30	Extended Roman for Vietnamese
		new String[] {},					//smExtArabic	31	Extended Arabic for Sindhi
		new String[] {},					//smUninterp	32	Uninterpreted symbols
	};

	private ScriptUtility()
	{
		// NOP
	}

	static final int scriptCodeFromRsrcID(int rsrcID)
	{
		int script = (rsrcID - (0x4000 - 0x200)) / 0x200;
		if (script < 0)
		{
			script = 0;
		}
		return script;
	}

	// TODO expand and use fallbacks
//	static final Iterator charsetIterator(int script)
//	{
//
//	}

	static final String scriptCodeToCharset(int script)
	{
		script = Math.min(script, SCRIPTID_TO_ENCODING.length - 1);
		String[] encodingArray = SCRIPTID_TO_ENCODING[script];
		if (encodingArray.length == 0)
		{
			return SCRIPTID_TO_ENCODING[0][0];
		}
		return encodingArray[0];
	}
}
