/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.mcm.campaign;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

/**
 * <p>Represents the results of a call to a Adobe Campaign instance.</p>
 *
 * <p>Instances of this class are considered to be consumed by a single thread, so the
 * implementation should not be considered threadsafe.</p>
 */
public interface CallResults {

    /**
     * Returns the (HTTP-) status of the call.
     *
     * @return The (HTTP-) status
     */
    int getStatus();

    /**
     * Retrieve a <code>Map</code> of the response headers.
     *
     * @return The response headers
     */
    Map<String, String> getResponseHeaders();

    /**
     * <p>Returns the body of the response as a stream.</p>
     *
     * <p>Caller is responsible for closing the stream.</p>
     *
     * @return The stream to access the body of the response
     */
    InputStream bodyAsStream() throws IOException;

    /**
     * Returns the body of the response as a <code>String</code>.
     *
     * @return The body of the response
     */
    String bodyAsString() throws IOException;

    /**
     * Should be called after the results have been completely consumed by the client to
     * ensure resources are properly cleaned up
     */
    void destroy();

    /**
     * Returns the complete URL of the originating request (debugging purposes only!).
     *
     * @return The complete URL
     */
    String getCompleteURL();

}
