/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.emailprovider.types;

import java.util.Map;

/**
 * This is the base type for all entities defined for email provider interface.
 * It has setter and getter methods for an identifier (id) to identify the entities.
 */
public interface BaseType {
    /**
     * Get the id of the entity.
     * @return The identifier of the entity
     */
    public String getId();

    /**
     * Set the id of the entity
     * @param id Entity identifier.
     */
    public void setId(String id) ;

    /**
     * Get entity config parameters (if any). These have been added to take care of any email provder specific paramaters.
     * @return a map containing custom properties.
     */
    public Map<String, Object> getParams();

    /**
     * Set entity config parameters (if any). These have been added to take care of any email provder specific paramaters.
     * @param params A map containing custom parameters.
     */
    public void setParams(Map<String, Object> params);

    /**
     * Add a custom parameter to the entity.
     * @param paramName The parameter name
     * @param paramValue The parameter value
     */
    public void addParam(String paramName, Object paramValue);

    /**
     * Get a custom param value
     * @param paramName name of parameter
     * @return value of parameter
     */
    public Object getParam(String paramName);
}
