/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting.helpers;

/**
 * Class that is used for wrapping integers in collections.
 */
public class IntWrapper {

    /**
     * The wrapped int value
     */
    private final int value;

    /**
     * Wraps the specified value.
     *
     * @param value The value to be wrapped
     */
    public IntWrapper(int value) {
        this.value = value;
    }

    /**
     * Gets the wrapped value.
     *
     * @return The wrapped value
     */
    public int get() {
        return this.value;
    }

    /**
     * {@inheritDoc}
     */
    public int hashCode() {
        return this.value;
    }

    /**
     * {@inheritDoc}
     */
    public boolean equals(Object o2) {
        if (o2 instanceof Integer) {
            return (((Integer) o2) == this.value);
        }
        return (o2 instanceof IntWrapper) && (((IntWrapper) o2).value == this.value);
    }

}
