/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.parser.taghandlers;

import java.util.HashMap;
import java.util.Map;

import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;

/**
 * The title tag handler is used to extract the page title of the
 * input HTML document.
 * 
 * <p>
 * This tag handler is registered against the markup of type < title >. That implies
 * this tag handler will come into action whenever the design importer framework
 * encounters an HTML tag matching the rule this handler is defined against.
 * </p>
 *
 * @see com.day.cq.wcm.designimporter.parser.taghandlers.factory.TitleTagHandlerFactory
 */
public class TitleTagHandler extends AbstractTagHandler {

    private String title;

    public Object getContent(HTMLContentType htmlContentType) {
        Map<String, String> metadata = new HashMap<String, String>();
        if (title != null && !title.trim().equals("")) metadata.put("title", title);
        return metadata;
    }

    public boolean supportsContent(HTMLContentType htmlContentType) {
        return htmlContentType == HTMLContentType.META;
    }

    @Override
    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        super.endHandling(uri, localName, qName);
        title = htmlBuffer.toString();
    }
}
