/*##############################################################################
 # ADOBE CONFIDENTIAL
 # ___________________
 #
 #  Copyright 2020 Adobe
 #  All Rights Reserved.
 #
 # NOTICE: All information contained herein is, and remains
 # the property of Adobe and its suppliers, if any. The intellectual
 # and technical concepts contained herein are proprietary to Adobe
 # and its suppliers and are protected by all applicable intellectual
 # property laws, including trade secret and copyright laws.
 # Dissemination of this information or reproduction of this material
 # is strictly forbidden unless prior written permission is obtained
 # from Adobe.
 #############################################################################*/
package com.day.cq.xss.taglib;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;

import com.day.cq.xss.XSSProtectionService;

/**
 * This class implements a tag that can be used for protecting a String that is provided
 * as a request attribute.
 * @deprecated
 */
@Deprecated
public class ProtectStringAsAttribute extends ProtectBody {

    /**
     * Name of attribute where the result is saved to
     */
    private String name;

    /**
     * Get the name of the attribute where the result is saved to.
     *
     * @return Attribute name
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name to the attribute where the result is saved to.
     *
     * @param name Attribute name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Executes the XSS removal and sets the cleaned HTML to the request attribute as
     * specified.
     */
    @Override
    public int doAfterBody() throws JspException {
        try {
            XSSProtectionService service = Utils.getService(this.pageContext);
            if (service != null) {
                BodyContent bc = this.getBodyContent();
                String src = bc.getString();
                bc.clearBody();
                ServletRequest req = this.pageContext.getRequest();
                req.setAttribute(this.name, service.protectForContext(
                        this.getProtectionContext(), src, getPolicy()));
            }
        } catch (Exception e) {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

}
