/*
*
*	File: InvalidFontException.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font;

/**
 * Generally thrown when a font is incorrect in a way that cannot be worked around.
 * 
 * <h4>Synchronization</h4>
 * 
 * <p>This class has the same threadsafety guarantees as java.lang.Exception.</p>
 */

public class InvalidFontException extends FontException {
  
  static final long serialVersionUID = 1;

  public InvalidFontException () {
    super ();
  }

  public InvalidFontException (Font font) {
    super (font);
  }

  public InvalidFontException (String message) {
    super (message);
  }

  public InvalidFontException (String message, Font font) {
    super (message, font);
  }

  public InvalidFontException (String message, Throwable cause) {
      super (message, cause);
  }

  public InvalidFontException (String message, Throwable cause, Font font) {
      super (message, cause, font);
  }

  public InvalidFontException (Throwable cause) {
      super (cause);
  }

  public InvalidFontException (Throwable cause, Font font) {
      super (cause, font);
  }
}