/*
 *
 *	File: ArrayComparitor.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font.postscript;


/**
 * Functionality similar to class Arrays, but which can work on parts of arrays.
 *
 * <h4>Synchronization</h4>
 * 
 * This class represents a namespace
 * and does not contain instance data or mutable static data. It is therefore threadsafe.
 */
final public class SubArrays {

	/**
	 * 
	 * @param a1 The first buffer to compare
	 * @param a1start The offset into a1 to begin comparing
	 * @param a2 The second buffer to compare
	 * @param a2start The offset into a2 to begin comparing
	 * @param numToCompare If numToCompare extends beyond the end of a1 and a2, arrayCompare only 
	 * compares to the end of the buffers. 
	 * @return true if the subarrays are the same, false otherwise
	 */
    public static boolean arrayCompare(byte[] a1, int a1start, byte[] a2, int a2start, int numToCompare)
    {
        int end = a1start + numToCompare;
        int firstEnd = 0;
        int secondEnd = 0;
        
        // end goes beyond the end of a1
        if (a1.length < end)
        {
        	firstEnd = end - a1.length;
        }
        
        // passing the end of a2
        if (a2.length < a2start + numToCompare)
        {
        	secondEnd = a2start + numToCompare - a2.length;
        }
        
        // if the buffers are too short by different amounts, they cannot
        // be the same.
        if (firstEnd != secondEnd)
        	return false;
        
        end -= secondEnd;
        
        
        for (; a1start < end; a1start++, a2start++) {
            if (a1[a1start] != a2[a2start])
                return false;
        }
        return true;
    }
    
    public static boolean stringBufferCompare(StringBuffer a1, int a1start, StringBuffer a2, int a2start, int numToCompare)
    {
        int end = a1start + numToCompare;
        int firstEnd = 0;
        int secondEnd = 0;
        
        // end goes beyond the end of a1
        if (a1.length() < end)
        {
        	firstEnd = end - a1.length();
        }
        
        // passing the end of a2
        if (a2.length() < a2start + numToCompare)
        {
        	secondEnd = a2start + numToCompare - a2.length();
        }
        
        // if the buffers are too short by different amounts, they cannot
        // be the same.
        if (firstEnd != secondEnd)
        	return false;
        
        end -= secondEnd;
        
        
        for (; a1start < end; a1start++, a2start++) {
            if (a1.charAt(a1start) != a2.charAt(a2start))
                return false;
        }
        return true;
    }
}
