/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.i18n;

import java.util.Locale;

/**
 * Utility class for locale handling.
 */
public abstract class LocaleUtil {

    /**
     * Parses the given text to create its corresponding {@link Locale}. This
     * method supports "-" and "_" as locale element separator.
     * 
     * @param text string to parse
     * @return the {@link Locale}
     */
    public static Locale parseLocale(final String text) {
        final String[] elements = text.split("-|_");

        if (elements.length == 1)
            return new Locale(elements[0]);

        if (elements.length == 2)
            return new Locale(elements[0], elements[1]);

        if (elements.length >= 3)
            return new Locale(elements[0], elements[1], elements[2]);

        throw new IllegalArgumentException("Unparsable text: " + text);
    }

    /**
     * Converts the given locale to RFC 4646 format. e.g. "en_US" to "en-US".
     * 
     * @param locale the {@link Locale} to convert to RFC 4646 format
     * @return the string in RFC 4646 format corresponding to the submitted {@link Locale}
     */
    public static String toRFC4646(final Locale locale) {
        return locale.toString().replace('_', '-');
    }
}
