/* $Header: /Faultline/com/adobe/acrobat/filters/DCTjscan.java 1     9/25/98 6:35p Gdow $$NoKeywords: $ */
/*
  DCTjscan.java

  The various structures used by the JPEG encoder and decoder
  Split into multiple files

  (C) Copyright 1997 Adobe Systems Inc.  All rights reserved.

  Modification log:
    5/27/97 Marc Kaufman - Java version
    2/20/97 Edward Fiala -  Version 3010 of the DCT code
*/
package com.adobe.internal.pdftoolkit.core.filter;


/* jscan contains information for a particular scan component and a pointer
 to the jframe struct for that component, from which the rest of the
 information about the component can be obtained.  DCCodeTableId and
 ACCodeTableId are indices which select the coding table from the
 components of the most recent DHT marker.  dcc and acc are pointers derived
 from DCCodeTableId and ACCodeTableId.

 The encoder produces interleaved scans only with scan component order
 identical to frame component order.  Progressive encoding occurs in a
 series of scans for which the first DC scan is interleaved, AC scans are
 all single-component, and DC scans after the first may be either
 interleaved or single component.

 The decoder ...
 */
class DCTjscan
{
    DCTdec_code_struct  acc;            /* AC coding table */
    DCTdec_code_struct  dcc;            /* DC coding table */
    DCTjframe           jpframe;        /* Pointer to frame params for this scan comp. */
    int                 prev_dc;        /* DC prediction. */
    int                 DCCodeTableId;
    int                 ACCodeTableId;  /*** Need to expand this to, say, 5 items */

    DCTjscan()
    {
        jpframe = null;
    }
}
