/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa;

import java.io.*;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import com.adobe.xfa.ut.ExFull;

/**
 * 
 * Class to translate an XML stream using a XSL translation stream
 * 
 * <p>
 * Allowing the user to construct XSLTransltor from XSL InputStream or StreamSource
 * in order to process xml InputStream or StreamSource to create OutputStreamWriter, 
 * or StreamResult type.
 * </p>
 * @exclude from published api for now -- Gene "Jingwen" Wang, July 2007.
 */

public class XSLTranslator {
	private final Transformer transformer;

	public XSLTranslator(StreamSource ss) {
		try {
			TransformerFactory tFactory = TransformerFactory.newInstance();
			transformer = tFactory.newTransformer(ss);
		} catch (Exception oEx) {
			throw new ExFull(oEx);
		}
	}

	public XSLTranslator(InputStream is) {
		this(new StreamSource(is));
	}

	public void process(InputStream iStream, OutputStream oStream) {
		try {
    		OutputStreamWriter oWriter = new OutputStreamWriter(oStream, "UTF-8"); 
    		process(new StreamSource(iStream), new StreamResult(oWriter));
		} catch (Exception oEx) {
			throw new ExFull(oEx);
		}
	}

	public void process(StreamSource oXMLInStream, StreamResult oOutTextStream) {
		try {
			this.transformer.transform(oXMLInStream, oOutTextStream);
		} catch (Exception oEx) {
			throw new ExFull(oEx);
		}
	}
}
