/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.content;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;

/**
 * An element that creates a unit of data content representing a
 *              time conforming to a subset of ISO 8601 format.
 *
 * @exclude from published api.
 */
public final class TimeValue extends Content {
	public TimeValue(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.TIME, XFA.TIME, null, XFA.TIMETAG, XFA.TIME);
	}

	public boolean equals(Object object) {
		
		if (this == object)
			return true;
		
		return super.equals(object) &&
			getValue().equals(((TimeValue) object).getValue());
	}
	
	public int hashCode() {
		return super.hashCode() ^ getValue().hashCode();
	}

	public ScriptTable getScriptTable() {
		return TimeScript.getScriptTable();
	}

	/**
	 * Get the time stored in this element
	 * 
	 * @return the time string.
	 */
	public String getValue() {
		return getStrValue();
	}

	/**
	 * Set the time value within this element
	 * 
	 * @param sText
	 *            a string to set/replace the time stored in this element
	 */
	public void setValue(String sText) {
		super.setStrValue(sText, true, false);
	}

	/**
	 * Cast this element to a String. This allows this object to be used in
	 * contexts where a string is expected without needing to explicitly call
	 * getValue().
	 * 
	 * @return the time value.
	 */
	public String toString() {
		return getValue();
	}

}
