package com.adobe.xfa.template;

import com.adobe.xfa.Arg;
import com.adobe.xfa.Element;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ObjScript;
import com.adobe.xfa.ProtoableNodeScript;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptTable;

/**
 * @exclude from published api
 */

public class InstanceManagerScript extends ProtoableNodeScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
			ObjScript.moScriptTable,
			"instanceManager",
			new ScriptPropObj[] {
				new ScriptPropObj(InstanceManagerScript.class, "min", "getNothing", null, Arg.INTEGER, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_GETMININSTANCES_DESC, 0*/, 0),
				new ScriptPropObj(InstanceManagerScript.class, "max", "getNothing", null, Arg.INTEGER, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_GETMAXINSTANCES_DESC, 0*/, 0),
				new ScriptPropObj(InstanceManagerScript.class, "count", "getNothing", "setNothing", Arg.INTEGER, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_COUNTINSTANCES_DESC, 0*/, 0),
				new ScriptPropObj(InstanceManagerScript.class, "occur", "getOccur", null, Arg.OBJECT, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_CHILDDESC_OCCUR, 0*/, 0),
			},		
			new ScriptFuncObj[] {
				new ScriptFuncObj(InstanceManagerScript.class, "setInstances", "doNothing", Arg.EMPTY,
					new int[] { Arg.INTEGER/*, XFA_IS_FORM_SETINSTANCES_PARAM1*/ }, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_SETINSTANCES_DESC, 0, null*/, 0),
				new ScriptFuncObj(InstanceManagerScript.class, "addInstance", "doNothing", Arg.OBJECT,
					new int[] { Arg.BOOL/*, XFA_IS_FORM_ADDINSTANCE_PARAM1*/ }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_ADDINSTANCE_DESC, XFA_IS_FORM_ADDINSTANCE_RET, null*/, 0),
				new ScriptFuncObj(InstanceManagerScript.class, "removeInstance", "doNothing", Arg.EMPTY,
					new int[] { Arg.INTEGER/*, XFA_IS_FORM_REMOVEINSTANCE_PARAM1*/ }, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_REMOVEINSTANCE_DESC, 0, null*/, 0),
				new ScriptFuncObj(InstanceManagerScript.class, "moveInstance", "doNothing", Arg.EMPTY,
					new int[] { Arg.INTEGER, Arg.INTEGER/*, INTEGER,XFA_IS_FORM_MOVEINSTANCE_PARAM1, XFA_IS_FORM_MOVEINSTANCE_PARAM2*/ }, 2, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_MOVEINSTANCE_DESC, 0, null*/, 0),
				new ScriptFuncObj(InstanceManagerScript.class, "insertInstance", "doNothing", Arg.OBJECT,
					new int[] { Arg.INTEGER, Arg.BOOL/*, XFA_IS_FORM_INSERTINSTANCE_PARAM1,XFA_IS_FORM_ADDINSTANCE_PARAM1*/ }, 1, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_INSERTINSTANCE_DESC, XFA_IS_FORM_ADDINSTANCE_RET, null*/, 0),
			}
		);

	public static ScriptTable getScriptTable() {
		return moScriptTable;	
	}

	public static void getNothing(Obj oObj, Arg oRetVal) {
		// do nothing
	}

	public static void setNothing(Obj oObj, Arg propertyValue) {
		// do nothing
	}
	
	public static void getOccur(Obj oObj, Arg oRetVal) {
		if (oObj instanceof InstanceManager) {
			InstanceManager oManager = (InstanceManager)oObj;
			if (oManager != null) {
				Element oOccur = oManager.getOccur();
				oRetVal.setObject(oOccur);
			}
		}
	}
	
	public static void doNothing(Obj oObj, Arg oRetVal, Arg oArgs[], int nParamCount) {
		// do nothing
	}
}
