/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.contentsync.handler.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.Map;

/**
 * The {@code RequestResponseFactory} helps in creating custom
 * {@code HttpServletRequest} and {@code HttpServletResponse}
 * objects for use in Content Sync update handlers.
 *
 * @see com.day.cq.contentsync.handler.AbstractSlingResourceUpdateHandler
 */
public interface RequestResponseFactory {
    /**
     * Create a request with given method and URI.
     *
     * @param method The request method
     * @param uri    The uri
     * @return The request object
     */
    public HttpServletRequest createRequest(String method, String uri);

    /**
     * Create a request with given method, URI and parameters.
     *
     * @param method The request method
     * @param uri    The uri
     * @param params The map of request parameters
     * @return The request object
     */
    public HttpServletRequest createRequest(String method, String uri, Map<String, Object> params);

    /**
     * Create a response with given output stream.
     *
     * @param out The output stream
     * @return The response object
     */
    public HttpServletResponse createResponse(OutputStream out);

    /**
     * Get MD5 hash for the response's body.
     *
     * @param response The response
     * @return MD5 hash of response body
     * @deprecated
     */
    @Deprecated
    public String getMD5(HttpServletResponse response);
}
