/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.api.renditions;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;

/**
 * Defines a template for creating renditions using the
 * {@link com.day.cq.dam.api.renditions.RenditionMaker}.
 *
 * @since 6.0
 */
public interface RenditionTemplate {

    /**
     * Create or update an rendition for the given asset based on this template.
     *
     * @param asset the asset for which a rendition should be created or updated
     * @return created or updated rendition or <code>null</code> if it failed
     */
    Rendition apply(Asset asset);
}
