/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter;

/**
 * Lets you have fine grained control over how the canvas is built. This options object lets you
 * switch various build functionalities on or off.
 *
 */
public class CanvasBuildOptions {

    private boolean buildPageNodes = true;

    private boolean buildHeadClientJSLibs = true;

    private boolean buildHeadClientCSSLibs = true;

    private boolean buildBodyClientJSLibs = true;

    private boolean buildBodyClientCSSLibs = true;

    private boolean buildCanvasComponent = true;

    /**
     * Indicates whether the canvas component nodes will be built or not
     *
     * @return true if the canvas component nodes building is turned on
     */
    public boolean isBuildPageNodes() {
        return buildPageNodes;
    }

    /**
     * Lets you control the building of canvas component nodes.
     *
     * @param buildPageNodes Boolean to turn canvas component building on or off
     */
    public void setBuildPageNodes(boolean buildPageNodes) {
        this.buildPageNodes = buildPageNodes;
    }

    /**
     * Indicates whether the head javascript clientlibs will be built or not
     *
     * @return true if the head javascript clientlibs building is turned on
     */
    public boolean isBuildHeadClientJSLibs() {
        return buildHeadClientJSLibs;
    }

    /**
     * Lets you control the building of head javascript clientlibs.
     *
     * @param buildHeadClientJSLibs Boolean to turn head javascript clientlibs building on or off
     */
    public void setBuildHeadClientJSLibs(boolean buildHeadClientJSLibs) {
        this.buildHeadClientJSLibs = buildHeadClientJSLibs;
    }

    /**
     * Indicates whether the head css clientlibs will be built or not
     *
     * @return true if the head css clientlibs building is turned on
     */
    public boolean isBuildHeadClientCSSLibs() {
        return buildHeadClientCSSLibs;
    }

    /**
     * Lets you control the building of head css clientlibs.
     *
     * @param buildHeadClientCSSLibs Boolean to turn head css clientlibs building on or off
     */
    public void setBuildHeadClientCSSLibs(boolean buildHeadClientCSSLibs) {
        this.buildHeadClientCSSLibs = buildHeadClientCSSLibs;
    }

    /**
     * Indicates whether the body javascript clientlibs will be built or not
     *
     * @return true if the body javascript clientlibs building is turned on
     */
    public boolean isBuildBodyClientJSLibs() {
        return buildBodyClientJSLibs;
    }

    /**
     * Lets you control the building of body javascript clientlibs.
     *
     * @param buildBodyClientJSLibs Boolean to turn body javascript clientlibs building on or off
     */
    public void setBuildBodyClientJSLibs(boolean buildBodyClientJSLibs) {
        this.buildBodyClientJSLibs = buildBodyClientJSLibs;
    }

    /**
     * Indicates whether the body css clientlibs will be built or not
     *
     * @return true if the body css clientlibs building is turned on
     */
    public boolean isBuildBodyClientCSSLibs() {
        return buildBodyClientCSSLibs;
    }

    /**
     * Lets you control the building of body css clientlibs.
     *
     * @param buildBodyClientCSSLibs Boolean to turn body css clientlibs building on or off
     */
    public void setBuildBodyClientCSSLibs(boolean buildBodyClientCSSLibs) {
        this.buildBodyClientCSSLibs = buildBodyClientCSSLibs;
    }

    /**
     * Indicates whether the canvas component will be built or not
     *
     * @return true if the canvas component building is turned on
     */
    public boolean isBuildCanvasComponent() {
        return buildCanvasComponent;
    }

    /**
     * Lets you control the building of the canvas component.
     *
     * @param buildCanvasComponent Boolean to turn the canvas component building on or off
     */
    public void setBuildCanvasComponent(boolean buildCanvasComponent) {
        this.buildCanvasComponent = buildCanvasComponent;
    }

    /**
     * Indicates whether the head clientlibs will be built or not
     *
     * @return true if the head clientlibs building is turned on
     */
    public boolean isBuildHeadClientLibs() {
        return isBuildHeadClientCSSLibs() && isBuildHeadClientJSLibs();
    }

    /**
     * Lets you control the building of clientlibs. This is a convenience method for setting head js/css clientlibs flags in one go.
     *
     * @param buildHeadClientLibs Boolean to turn head clientlibs (both js & css) building on or off
     */
    public void setBuildHeadClientLibs(boolean buildHeadClientLibs) {
        setBuildHeadClientCSSLibs(buildHeadClientLibs);
        setBuildHeadClientJSLibs(buildHeadClientLibs);
    }

    /**
     * Indicates whether the body clientlibs will be built or not
     *
     * @return true if the body clientlibs building is turned on
     */
    public boolean isBuildBodyClientLibs() {
        return isBuildBodyClientCSSLibs() && isBuildBodyClientJSLibs();
    }

    /**
     * Lets you control the building of clientlibs. This is a convenience method for setting body js/css clientlibs flags in one go.
     *
     * @param buildBodyClientLibs Boolean to turn body clientlibs (both js & css) building on or off
     */
    public void setBuildBodyClientLibs(boolean buildBodyClientLibs) {
        setBuildBodyClientCSSLibs(buildBodyClientLibs);
        setBuildBodyClientJSLibs(buildBodyClientLibs);
    }

    /**
     * Indicates whether the body clientlibs will be built or not
     *
     * @return true if the body clientlibs building is turned on
     */
    public boolean isBuildClientLibs() {
        return isBuildBodyClientLibs() && isBuildHeadClientLibs();
    }

    /**
     * Lets you control the building of clientlibs. This is a convenience method for setting head/body js/css clientlibs flags in one go.
     *
     * @param buildClientLibs Boolean to turn all clientlibs building on or off
     */
    public void setBuildClientLibs(boolean buildClientLibs) {
        setBuildHeadClientLibs(buildClientLibs);
        setBuildBodyClientLibs(buildClientLibs);
    }

}
