/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

import aQute.bnd.annotation.ProviderType;

/**
 * Represents a version of a content item (like the entire fragment, an element or a
 * variation of it).
 *
 * <p>Instances of this interface are considered to hold "lightweight" representations of a
 * version - they're just defining the basic data required to reference a version, not to
 * access its content.</p>
 *
 * <p>To access the actual versioned content, see
 * {@link Versionable#getVersionedContent(VersionDef)}.</p>
 */
@ProviderType
public interface VersionDef {

    /**
     * Gets a text-based identifier for the represented version.
     *
     * <p>The identifier has to be unique for the implementation. Otherwise, it is
     * left to the implementation what that identifier may look like.</p>
     *
     * @return The text-based identifier for the version
     */
    String getIdentifier();

    /**
     * Gets a human-readable description of the represented version.
     *
     * @return The human-readable description for the version
     */
    String getDescription();

}
