/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2019 Adobe Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Incorporated.
 */

package com.adobe.cq.dam.cfm.content;

import aQute.bnd.annotation.ProviderType;

import java.util.List;

/**
 * <p>Provides a helper for shared logic in content fragment component implementations.</p>
 */
@ProviderType
public interface ComponentHelperService {

    /**
     * <p>Extract the list of valid paragraphs detected in the provided HTML content. Usually returned by renderer.</p>
     *
     * @param content The rendered HTML containing paragraph elements (i.e p, h1, h2, h3, h4, h5, h6).
     * @return A list representing the paragraph elements html snippets in the natural appearing order.
     */
    List<String> listAllParagraphs(String content);

}