/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.smartcontent;

/**
 * <p>This class represents an exception while processing content within Smart Content
 * Authoring.</p>
 */
public class SmartContentException extends Exception {

    /**
     * <p>Creates a new {@code SmartContentException}.</p>
     *
     * @param message Text describing the exception
     */
    public SmartContentException(String message) {
        super(message);
    }

    /**
     * <p>Creates a new nested {@code SmartContentException}.</p>
     *
     * @param message Text describing the exception
     * @param cause The nested {@code Exception}
     */
    public SmartContentException(String message, Throwable cause) {
        super(message, cause);
    }

}
