/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2016 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.adobe.cq.xf;

/**
 * Constants used by the Experience Fragments feature.
 */
public final class ExperienceFragmentsConstants {

    /**
     * Used in filtering the Experience Fragments that will be displayed in the side-panel of the editor
     */
    public static final String PN_SHOW_IN_EDITOR="cq:xfShowInEditor";

    /**
     * The resource type of the Experience Fragment "master" page
     */
    public static final String RT_EXPERIENCE_FRAGMENT_MASTER = "cq/experience-fragments/components/experiencefragment";

    /**
     * The resource type of an Experience Fragment page
     */
    public static final String RT_EXPERIENCE_FRAGMENT_PAGE = "cq/experience-fragments/components/xfpage";

    /**
     * The resource type of the Experience Fragment component used in the editor
     */
    public static final String RT_EXPERIENCE_FRAGMENT_COMPONENT = "cq/experience-fragments/editor/components/experiencefragment";

    /**
     * The resource type of the Experience Fragment Core component used in the editor
     */
    public static final String RT_EXPERIENCE_FRAGMENT_CORE_COMPONENT = "core/wcm/components/experiencefragment/v1/experiencefragment";

    /**
     * The property of the editor component which holds the path to the experience fragment variation page
     */
    public static final String PN_FRAGMENT_PATH = "fragmentPath";

    /**
     * The property of the editor core component which holds the path to the experience fragment variation page
     */
    public static final String PN_CORE_FRAGMENT_PATH = "fragmentVariationPath";

    /**
     * The property of the Experience Fragment variant that specifies variant's type
     */
    public static final String PN_XF_VARIANT_TYPE = "cq:xfVariantType";

    /**
     * Default value for "cq:xfVariantType"
     */
    public static final String CUSTOM_XF_VARIANT_TYPE = "custom";

    /**
     * The type of the "facebook" variation
     */
    public static final String TYPE_XF_VARIANT_FACEBOOK = "facebook";
    /**
     * The type of the "pinterest" variation
     */
    public static final String TYPE_XF_VARIANT_PINTEREST = "pinterest";
    /**
     * The type of the "web" variation
     */
    public static final String TYPE_XF_VARIANT_WEB = "web";

    /**
     * The property which indicates the master variation (usually is the first one created)
     */
    public static final String PN_XF_MASTER_VARIATION = "cq:xfMasterVariation";

    /**
     * The property which indicates the social media post ID
     */
    public static final String PN_XF_POST_ID = "postId";

    /**
     * The property which indicates the last social media action status
     * One of: 'Not Posted', 'Posted', 'Deleted'.
     */
    public static final String PN_XF_SOCIAL_ACTION_STATUS = "cq:xfSocialActionStatus";

    /**
     * The property which indicates the date of the last social media action
     */
    public static final String PN_XF_SOCIAL_ACTION = "cq:xfSocialActionDate";

    /**
     * The property which holds the offerId from Adobe Target, if the variation is exported as an offer
     */
    public static final String PN_TARGET_OFFER_ID = "cq:targetOfferId";

    /**
     * The path where experience fragments are stored
     */
    public static final String CONTENT_PATH = "/content/experience-fragments";


    /**
     * The export format property to Adobe Target. Possible values: 'html', 'json' and 'html,json'
     */
    public static final String PN_ADOBE_TARGET_FORMAT = "cq:adobeTargetExportFormat";

    /**
     * The workspace ID property to export the Experience Fragments to a specific Adobe Target workspace
     */
    public static final String PN_ADOBE_TARGET_WORKSPACE = "cq:adobeTargetExportWorkspace";

    /**
     * The cloud service configs paths property
     */
    public static final String PN_CLOUD_SERVICE_CONFIGS = "cq:cloudserviceconfigs";

    /**
     * The externalizer name property to Adobe Target. Possible values: 'author', 'publish','local' and custom ones
     */
    public static final String PN_ADOBE_TARGET_EXTERNALIZER  = "cq:externalizerName";

    private ExperienceFragmentsConstants() {
        // no-op
    }

}
