/*
 *
 *	File: MetricFile.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font.type1;

import java.net.URL;

/**
 * Represents the secondary file needed by type1 fonts to access kerning data, etc.
 * 
 * Possible examples of metric files are .pfm, .afm, and suitcase files. 
 *
 * <h4>Synchronization</h4>
 * 
 * This class is immutable after contruction and contains no mutable
 * static data. It is therefore threadsafe.
 */
public abstract class MetricFile {
    private final URL location;
    
    MetricFile(URL url)
    {
        location = url;
    }
    
    /** Fetch the kern value for 2 glyphIDs. */
    public abstract double getKernValue(String leftGlyphName, String rightGlyphName);
    
    /** Fetch the platform name for the font associated with this file. 
     * Returns null if the file does not contain this information. 
     */
    public abstract String getFamilyName();
    
    /** Fetch the postscript name for the font associated with this file. */
    public abstract String getFontName();
    
    /** Fetch the weight for this font. 
     * Returns 0 if the file does not contain this information .
     */
    public abstract int getWeight();
    
    final public URL getLocation() {return location;}
    
}
