/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.security.user;

import org.apache.sling.api.resource.ResourceResolver;

/**
 * The {@code SSLConfigurationService} allows verifying whether a valid SSL configuration is present.
 */
public interface SSLConfigurationService {

    /**
     * The id of the service user holding the key store.
     */
    String SSL_SERVICE_USER_ID = "ssl-service";

    /**
     * The name of the alias under which key and certificate are stored in the key store.
     */
    String KEYSTORE_ALIAS = SSL_SERVICE_USER_ID;

    /**
     * Verifies whether an HTTPs listener is configured and available. The method must be called with the resource
     * resolver of the admin user itself. Membership of the administrators group is insufficient.
     * <br>
     * The configuration is considered valid in the following circumstances:
     * <ul>
     * <li>An OSGi configuration for the Granite SSL Connector Factory is present</li>
     * <li>The "Keystore User" ({@link #SSL_SERVICE_USER_ID} normally) from the Granite SSL Connector Factory
     * configuration exists and its key store contains a valid private key and certificate (chain) under the correct
     * alias ({@link #KEYSTORE_ALIAS} normally)</li>
     * <li>The {@code SSLConfigurationService} is able to perform an HTTPS request upon its own instance
     * and the return code is &lt;400 or 401. Note: invalid (i.e. self-signed) SSL certificates are silently
     * accepted. Note: The hostname to connect to is derived from the Sling Topology local endpoint property.</li>
     * </ul>
     *
     * @param resolver The admin-user resource resolver to access configuration and key store.
     * @return {@code true} if the SSL configuration is present and valid.
     * @throws SecurityException If the resolver is not the one of the admin user.
     */
    boolean isSSLConfigured(ResourceResolver resolver) throws SecurityException;
}
