/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.exec;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.metadata.MetaDataMap;

/**
 * Service Interface to support execution of 3rd party workflow step code.
 * <code>StepExecutor</code> can be used to support 3rd part code to execute workflow
 * steps, however the preferred method is to implement the <code>WorkflowProcess</code> interface.
 *
 * @see com.adobe.granite.workflow.exec.WorkflowProcess
 */

// This interface is implemented by a service in CQ proper to support the
// running of com.day.cq.workflow.exec.WorkflowProcess steps. com.adobe.granite.workflow.core.job.HandlerBase uses this
// service to determine if a step is supported by the legacy runner and executes it
public interface StepExecutor {

    /**
     * Execute the step associate with resource.
     * @param workflowStepResource the resource identifying the code to execute for this workflow step.
     * @param workItem the workitem associate with the current step.
     * @param workflowSession the current workflow session
     * @param metaData the workflow step's metadata
     * @throws com.adobe.granite.workflow.WorkflowException thrown in case
     *     something goes wrong during execution
     */
    void execute(String workflowStepResource, WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException;

    /**
     * Returns true if this service can process the specified resource, false otherwise.
     * @param workflowStepResource the resource identifying the code to execute for this workflow step.
     * @return true if this service can process the specified resource, false otherwise.
     */
    boolean canExecute(String workflowStepResource);
}
