/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.workflow.exec.filter;

import com.adobe.granite.workflow.exec.InboxItem;

/**
 * The <code>InboxItemFilter</code> interface allows filter implementations
 * that can be used to filter specific <code>{@link com.adobe.granite.workflow.exec.InboxItem}s</code>
 */
public interface InboxItemFilter {
    /**
     * This method returns <code>true</code> if the given <code>{@link com.adobe.granite.workflow.exec.InboxItem}</code>
     * matches the filter criteria.
     *
     * @param inboxItem <code>{@link com.adobe.granite.workflow.exec.InboxItem}</code> to check
     *
     * @return <code>true</code> if the given <code>{@link com.adobe.granite.workflow.exec.InboxItem}</code>
     * matches the filter criteria.
     */
    boolean doInclude(InboxItem inboxItem);
}
