/*
 * File: TIFFCountingStreamWrapper.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2007 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.filter;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

import com.adobe.internal.io.SimpleByteWriterFactory;
import com.adobe.internal.io.ByteWriterFactory.Fixed;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;

/**
 * Counting wrapper for a TIFFInputStream or InflaterInputStream
 */
public class TIFFCountingStreamWrapper
{
	private Inflater mInflater;
	private FilterInputStream mFilterStream;

	public TIFFCountingStreamWrapper(InputStream inStm, CosDictionary paramsDict)
	throws PDFCosParseException, PDFIOException, PDFSecurityException
	{
		mInflater = new Inflater();
		FilterInputStream filterStream = new InflaterInputStream(inStm, mInflater);
		if (paramsDict != null) {
			FilterParams filterParams = FilterStream.buildFilterParams(paramsDict);
			filterStream = new TIFFInputStream(filterStream, filterParams);
		}
		mFilterStream = filterStream;
	}

	public TIFFCountingStreamWrapper(InputStream inStm, ASDictionary paramsDict) throws PDFInvalidParameterException
	{
		mInflater = new Inflater();
		FilterInputStream filterStream = new InflaterInputStream(inStm, mInflater);
		if (paramsDict != null) {
			FilterParams filterParams = FilterStream.buildFilterParams(paramsDict);
			filterStream = new TIFFInputStream(filterStream, filterParams);
		}
		mFilterStream = filterStream;
	}

	public void copyData(OutputStream outStm)
		throws IOException
	{
		IO.copy(mFilterStream, outStm);
		outStm.flush();
	}

	public InputByteStream getData()
		throws IOException
	{
		StreamManager streamManager = StreamManager.newInstance(new SimpleByteWriterFactory(), null);
		OutputByteStream outByteStm = streamManager.getUnregisteredOutputByteStream(Fixed.GROWABLE, 0);
		copyData(outByteStm.toOutputStream());
		return outByteStm.closeAndConvert();
	}

	public int getTotalIn()
	{
		return mInflater.getTotalIn();
	}

	public void close()
		throws IOException
	{
		mInflater.end();
		mFilterStream.close();
	}
}
