/* ****************************************************************************
*
*	File: SecurityKey.java
*
* ****************************************************************************
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
* ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.securityframework;


/**
 * <p>The security key is used to to authenticate the right to access an encrypted
 * PDF document and decrypt it. It is used when PDFDocument objects are unlock'ed.
 * </p>
 * <P>Use {@link com.adobe.internal.pdftoolkit.core.securityframework.SecurityLock} 
 * to encrypt the document.</P>
 */
public interface SecurityKey 
{
	/**
	 * @return SecurityManager that contains Security Handlers used to decrypt a PDF document
	 */
	SecurityManager getSecurityManager();		
}
