/* ****************************************************************************
*
*	File: SecurityKeyPKIInterface.java
*
* ****************************************************************************
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
* ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.securityframework.impl;

import java.util.Map;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityKey;

/**
 * This is a Security Key factory that 
 * can be used to instantiate different varieties of the password-based Security Keys.</P>
 * <P><B>Note</B>: When the abstract methods declared in this class are implemented
 * by the user, they will be contained in the objects that <code>newInstance()</code> methods return. </P>
 * @author itenenbo
 */
public interface SecurityKeyPKIInterface extends SecurityKey 
{
	/**
	 * <P>Create an object that represents credentials for the specified recipient 
	 * </P>
	 * @param recipient certificate credentials for the specified recipient.
	 * @return a Security Key object representing credentials for the specified recipient.
	 * @throws PDFSecurityException 
	 */
	abstract public SecurityKeyPKIInterface makeSecurityKey(Credentials recipient, Map encryptParams, SecurityProvidersImpl providers) 
    throws PDFSecurityException;
	
}
