/* ****************************************************************************
 *
 *	File: SecurityProvidersImpl.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

// @author itenenbo

package com.adobe.internal.pdftoolkit.core.securityframework.impl;

import java.security.Provider;
import java.security.SecureRandom;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.securityframework.PKCS7EnvelopedDataHandler;

public class SecurityProvidersImpl 
{
	private Provider mMD5;
	private Provider mRC4;
	private Provider mAES;
	private Provider mSHA1;
	private Provider mSHA1PRNG;
	private Provider mSHA256;
	private Provider mSHA384;
	private Provider mSHA512;
	private PKCS7EnvelopedDataHandler mPKCS7Handler;
	private SecureRandom mRandomGenerator;
	
	protected SecurityProvidersImpl(Provider md5, Provider rc4, Provider aes, 
			Provider sha1, Provider sha1prng, PKCS7EnvelopedDataHandler pkcs7Handler, SecureRandom randomGenerator)
	{
		mMD5 = md5;
		mRC4 = rc4;
		mAES = aes;
		mSHA1 = sha1;
		mSHA1PRNG = sha1prng;
		mPKCS7Handler = pkcs7Handler;
		mRandomGenerator = randomGenerator;
	}
	
	protected SecurityProvidersImpl(Provider md5, Provider rc4, Provider aes, 
			Provider sha1, Provider sha1prng, Provider sha256, Provider sha384, Provider sha512, PKCS7EnvelopedDataHandler pkcs7Handler, SecureRandom randomGenerator)
	{
		mMD5 = md5;
		mRC4 = rc4;
		mAES = aes;
		mSHA1 = sha1;
		mSHA1PRNG = sha1prng;
		mSHA256 = sha256;
		mSHA384 = sha384;
		mSHA512 = sha512;
		mPKCS7Handler = pkcs7Handler;
		mRandomGenerator = randomGenerator;
	}

	/**
	 * Returns AES provider
	 * @return AES provider
	 */
	public Provider getAES() 
	{
		return mAES;
	}

	/**
	 * Returns MD5 provider
	 * @return MD5 provider
	 */
	public Provider getMD5() 
	{
		return mMD5;
	}

	/**
	 * Returns RC4 provider
	 * @return RC4 provider
	 */
	public Provider getRC4() 
	{
		return mRC4;
	}

	/**
	 * Returns SHA1 provider
	 * @return SHA1 provider
	 */
	public Provider getSHA1() 
	{
		return mSHA1;
	}

	/**
	 * Returns SHA256 provider
	 * @return SHA256 provider
	 */
	public Provider getSHA256() 
	{
		return mSHA256;
	}
	
	/**
	 * Returns SHA384 provider
	 * @return SHA384 provider
	 */
	public Provider getSHA384() 
	{
		return mSHA384;
	}
	
	/**
	 * Returns SHA512 provider
	 * @return SHA512 provider
	 */
	public Provider getSHA512() 
	{
		return mSHA512;
	}
	
	/**
	 * Returns SHA1PRNG provider
	 * @return SHA1PRNG provider
	 */
	public Provider getSHA1PRNG() 
	{
		return mSHA1PRNG;
	}
	
	
	/**
	 * Returns PKCS7EnvelopedDataHandler
	 * @return PKCS7EnvelopedDataHandler
	 */
	public PKCS7EnvelopedDataHandler getPKCS7EnvelopedDataHandler()
	{
		return mPKCS7Handler;
	}

	/**
	 * Returns the SHA1PRNG provider, exception is thrown if it is null
	 * 
	 * @return SHA1PRNG Provider
	 * @throws PDFSecurityConfigurationException
	 */
	public Provider requireSHA1PRNG()
	throws PDFSecurityConfigurationException
	{
		Provider provider = getSHA1PRNG();
		if (provider == null)
		{
			throw new PDFSecurityConfigurationException("SHA1PRNG provider is not available");
		}
		return provider;
	}

	/**
	 * Returns the MD5 provider, exception is thrown if it is null
	 * 
	 * @return MD5 Provider
	 * @throws PDFSecurityConfigurationException
	 */
	public Provider requireMD5()
	throws PDFSecurityConfigurationException
	{
		Provider provider = getMD5();
		if (provider == null)
		{
			throw new PDFSecurityConfigurationException("MD5 provider is not available");
		}
		return provider;
	}

	/**
	 * Returns the RC4 provider, exception is thrown if it is null
	 * 
	 * @return RC4 Provider
	 * @throws PDFSecurityConfigurationException
	 */
	public Provider requireRC4()
	throws PDFSecurityConfigurationException
	{
		Provider provider = getRC4();
		if (provider == null)
		{
			throw new PDFSecurityConfigurationException("RC4 provider is not available");
		}
		return provider;
	}

	/**
	 * Returns the AES provider, exception is thrown if it is null
	 * 
	 * @return AES Provider
	 * @throws PDFSecurityConfigurationException
	 */
	public Provider requireAES()
	throws PDFSecurityConfigurationException
	{
		Provider provider = getAES();
		if (provider == null)
		{
			throw new PDFSecurityConfigurationException("AES provider is not available");
		}
		return provider;
	}

	
	/**
	 * Returns the SHA1 provider, exception is thrown if it is null
	 * 
	 * @return SHA1 Provider
	 * @throws PDFSecurityConfigurationException
	 */
	public Provider requireSHA1()
	throws PDFSecurityConfigurationException
	{
		Provider provider = getSHA1();
		if (provider == null)
		{
			throw new PDFSecurityConfigurationException("SHA1 provider is not available");
		}
		return provider;
	}
	
	/**
	 * Returns the SHA256 provider, exception is thrown if it is null
	 * 
	 * @return SHA256 Provider
	 * @throws PDFSecurityConfigurationException
	 */
	public Provider requireSHA256()
	throws PDFSecurityConfigurationException
	{
		Provider provider = getSHA256();
		if (provider == null)
		{
			throw new PDFSecurityConfigurationException("SHA256 provider is not available");
		}
		return provider;
	}
	
	/**
	 * Returns the SHA384 provider, exception is thrown if it is null
	 * 
	 * @return SHA384 Provider
	 * @throws PDFSecurityConfigurationException
	 */
	public Provider requireSHA384()
	throws PDFSecurityConfigurationException
	{
		Provider provider = getSHA384();
		if (provider == null)
		{
			throw new PDFSecurityConfigurationException("SHA384 provider is not available");
		}
		return provider;
	}
	
	/**
	 * Returns the SHA512 provider, exception is thrown if it is null
	 * 
	 * @return SHA512 Provider
	 * @throws PDFSecurityConfigurationException
	 */
	public Provider requireSHA512()
	throws PDFSecurityConfigurationException
	{
		Provider provider = getSHA512();
		if (provider == null)
		{
			throw new PDFSecurityConfigurationException("SHA512 provider is not available");
		}
		return provider;
	}
	
	/**
	 * Returns the PKCS7EnvelopedDataHandler, exception is thrown if it is null
	 * 
	 * @return PKCS7EnvelopedDataHandler
	 * @throws PDFSecurityConfigurationException
	 */
	public PKCS7EnvelopedDataHandler requirePKCS7EnvelopedDataHandler()
	throws PDFSecurityConfigurationException
	{
		PKCS7EnvelopedDataHandler pkc7Handler = getPKCS7EnvelopedDataHandler();
		if (pkc7Handler == null)
		{
			throw new PDFSecurityConfigurationException("PKCS7EnvelopedDataHandler provider is not available");
		}
		return pkc7Handler;
	}

	/**
	 * Returns random number generator
	 * @return random number generator
	 */
	public SecureRandom getRandomGenerator() {
		return mRandomGenerator;
	}

	/**
	 * Returns the random number generator, exception is thrown if it is null
	 * @return random number generator
	 * @throws PDFSecurityConfigurationException
	 */
	public SecureRandom requireRandomGenerator()
	throws PDFSecurityConfigurationException
	{
		SecureRandom randomGenerator = getRandomGenerator();
		if (randomGenerator == null)
		{
			throw new PDFSecurityConfigurationException("SecureRandom generator is not available");
		}
		return randomGenerator;
	}

}
