/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import com.adobe.xfa.protocol.Protocol;
import com.adobe.xfa.ut.Resolver;
import com.adobe.xfa.ut.StringUtils;


/**
 * An object that represents a relative path.  Yeah. Right.
 * 
 * @exclude from published api.
 */
public class UriPath {
	
	private	URL msRefFileLocation;
//	private	URL msExeFileLocation;


	public UriPath() {
	}

	public URL getFile(String sFileName) {
		
		if (StringUtils.isEmpty(sFileName))
			return null;

		File file = new File(sFileName);
		if (file.isAbsolute()) {
			if (file.exists()) {			
				try { 
					return file.toURL(); 
				} 
				catch (MalformedURLException e) { }
			}
				
			return null;
		}
		
		//
		// Referenced file location
		//
		if (msRefFileLocation != null) {
			
			// JavaPort: unlike the C++, we don't test for existence here
			//           Some expensive exists() code was removed from Protocol, but it
			//           could be reinstated if necessary.
			
			Protocol protocol = Resolver.getProtocol(msRefFileLocation.getProtocol());
			try {
				return new URL(msRefFileLocation, sFileName, protocol != null ? protocol.getURLStreamHandler() : null);
			} 
			catch (MalformedURLException e) { }
			
			return null; 
		}

//		//
//		// Executable file location
//		//
//		if (!StringUtils.isEmpty(msExeFileLocation)) {
//			file = new File(msExeFileLocation + File.separator + sFileName);
//			if (file.exists()) {
//				oFileId.append(file.getAbsolutePath());
//				return true;
//			}
//		}

		//
		// Current directory
		//
		File cwd = new File(System.getProperty("user.dir"));
		file = new File(cwd, sFileName);
		if (file.exists()) {
			try {
				return file.toURL();
			} catch (MalformedURLException e) { }
		}
		
		return null;
	}

	public URL getRefFileLocation() {
		return msRefFileLocation;
	}

	public void setRefFileLocation(URL location) {
		msRefFileLocation = location;
	}

//	public String getExeFileLocation() {
//		return msExeFileLocation;
//	}

//	public void setExeFileLocation(String sLocation) {
//		msExeFileLocation = sLocation;
//	}
}
