/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.content;


import com.adobe.xfa.Arg;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptTable;


/**
 * This class contains all the script functionality associated with the
 * ExDataValue class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class ExDataScript extends ContentScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ContentScript.moScriptTable,
		"exData",
		new ScriptPropObj[] {
			new ScriptPropObj(ExDataScript.class, "value", "getValue", "setValue", Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_CONTENT_EXDATA_VALUE_DESC,XFA_IS_CONTENT_EXDATA_VALUE_DESC*/, 0),
			new ScriptPropObj(ExDataScript.class, null, "getValue", "setValue", Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*,XFA_IS_CONTENT_EXDATA_VALUE_DESC,XFA_IS_CONTENT_EXDATA_VALUE_DESC*/, 0)
		},
		null
	);

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getValue(Obj pObj, Arg oRetVal) {
		// JEY TODO: check legacy formatting flag
		boolean bLegacySpaceBehavior = true;

		oRetVal.setString(((ExDataValue) pObj).getValue(false, false, bLegacySpaceBehavior));
	}

	public static void setValue(Obj pObj, Arg oArg) {
		((ExDataValue) pObj).setValue(oArg.getString());
	}

}
