/*
 *	ADOBE CONFIDENTIAL
 *
 *	Copyright 1995 - 2006 Adobe Systems Incorporated.  All Rights Reserved.
 *
 *	NOTICE:  All information contained herein is, and remains
 *	the property of Adobe Systems Incorporated and its
 *	suppliers, if any.	The intellectual and technical
 *	concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S.
 *	and Foreign Patents, patents in process, and are protected
 *	by trade secret or copyright law.  Dissemination of this
 *	information or reproduction of this material is strictly
 *	forbidden unless prior written permission is obtained from
 *	Adobe Systems Incorporated.
 */

package com.adobe.xfa.gfx;


/**
 * The graphic context allows the client to manage different graphic
 * attributes--attributes that are outside the scope of functionality
 * provided by XGA.  This class is intended to represent graphic
 * attributes that dont change the layout of text.
 * <p>
 * The client can attach a graphic context pointer to a graphic
 * attribute (jfGfxAttr) instance.  This will get passed through
 * intermediate layers and eventually find its way back to the client's
 * implementation of the graphic driver, where the client can act on it
 * accordingly.
 * </p>
 * @exclude from published api.
 */
public abstract class GFXGraphicContext implements GFXContext {
	static public boolean match (GFXGraphicContext c1, GFXGraphicContext c2) {
		if (c1 == c2) {
			return true;
		}
		if ((c1 == null) || (c2 == null)) {
			return false;
		}
		return c1.equals (c2);
	}
}
