/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.automation;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.ut.ResourceLoader;

/**
 * An element that describes a script.
 *
 * @exclude from published api.
 */
public final class Script extends ProtoableNode {
	
	private final static boolean ACROBAT_PLUGIN = ResourceLoader.loadProperty("ACROBAT_PLUGIN").equalsIgnoreCase("true");
	
	private boolean mbIsParsing;

	public Script(Element pParent, Node prevSibling) {
		super(pParent, prevSibling, null, XFA.SCRIPT, XFA.SCRIPT, null,
				XFA.SCRIPTTAG, XFA.SCRIPT);
		
		if (ACROBAT_PLUGIN) {
			// Watson 1675965: When the application is Acrobat, lock template script nodes from modification.
			// Other clients, such as Designer, do not want to lock template script nodes from modification.
			if (getModel().getLocalName().equals(XFA.TEMPLATE)) {
				setPermsLock(true);
			}
		}
	}

	public ScriptTable getScriptTable() {
		return ScriptScript.getScriptTable();
	}

	public String getValue() {
		TextNode t = getText(true, false, false);
		if (t == null)
			return "";
		return t.getValue();
	}

	public boolean isParsing() {
		return mbIsParsing;
	}

	public void isParsing(boolean bIsParsing) {
		mbIsParsing = bIsParsing;
	}

	public void setValue(String sValue) {
		TextNode pNode = getText(true, false, false);

		if (pNode != null)
			pNode.setValue(sValue,true,false);
	}
}
