/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.containers;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import com.adobe.xfa.ut.UnitSpan;

/**
 * An element that describes a region within a page eligible for receiving
 * content.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public final class ContentArea extends Container {
	private Measurement mZeroDefaultUnit;

	public ContentArea(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.CONTENTAREA, XFA.CONTENTAREA,
				null, XFA.CONTENTAREATAG, XFA.CONTENTAREA);
		mZeroDefaultUnit = null;
	}

	public Attribute defaultAttribute(int eTag) {
		if (eTag == XFA.WTAG || eTag == XFA.HTAG) {
			if (mZeroDefaultUnit == null) {
				mZeroDefaultUnit = new Measurement("", "0");
			}
			return mZeroDefaultUnit;
		}

		// Not special case, so let the base class handle it
		return super.defaultAttribute(eTag);
	}

	public UnitSpan getHeight() {
		Measurement oMeas = (Measurement)getAttribute(XFA.HTAG);
		return oMeas.getUnitSpan();
	}

	public UnitSpan getWidth() {
		Measurement oMeas = (Measurement)getAttribute(XFA.WTAG);
		return oMeas.getUnitSpan();
	}

	public boolean isHeightGrowSupported() {
		return false;
	}

	public boolean isWidthGrowSupported() {
		return false;
	}

}
