/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa.template.formatting;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.XFA;

/**
 * An element that describes how to fill the area inside an object.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class Fill extends ProtoableNode {

	public Fill(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.FILL, XFA.FILL, null, XFA.FILLTAG, XFA.FILL);
	}

	public Attribute defaultAttribute(int eTag) {
		// If we're an unspecified property, the default value of presence is
		// hidden.
		if (eTag == XFA.PRESENCETAG && isDefault(true))
			return EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(EnumAttr.PRESENCE_HIDDEN));

		// Not special case, so let the base class handle it
		return super.defaultAttribute(eTag);
	}

	public int defaultElement() {
		return XFA.SOLIDTAG;
	}

	/**
	 * @see ProtoableNode#isContextSensitiveAttribute(int)
	 * @exclude from published api.
	 */
	public boolean isContextSensitiveAttribute(int eTag) {
		return eTag == XFA.PRESENCETAG || 
			super.isContextSensitiveAttribute(eTag);
	}

}
