/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;

/**
 * This class contains a constant that is used as a guard around assertions
 * that are considered expensive. Since this field is static final, the
 * compiler will use this information to remove the assertions completely
 * from the generated byte code at compile time. A "release" mode build
 * would substitute a version of this class that changes this value to false,
 * thereby disabling assertions.
 * 
 * @author Andy Neilson
 * 
 * @exclude from public api.
 */
public class Assertions {

	public static final boolean isEnabled = false;

}
