/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.testandtarget;

import java.util.Locale;

/**
 * A {@code ReportType} enumerates all the possible report values from Adobe Target
 */
public enum ReportType {

    VISIT, VISITOR, IMPRESSION;

    public String getTestandTargetKey() {
        // note that for requests the key needs to be in lowercase
        // but the responses return it in uppercase

        return toString().toLowerCase(Locale.ENGLISH);
    }

    public static ReportType fromTestandTargetKey(String testandTargetKey) {
        for (ReportType reportType : ReportType.values())
            if (reportType.getTestandTargetKey().equalsIgnoreCase(testandTargetKey))
                return reportType;

        return null;
    }
}
