/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.testandtarget;

import java.util.Map;

/**
 * Abstracts the parameters to be sent in a Test and Target Http API call
 */
public interface TestandtargetHttpParameters {
    
    /**
     * Return the query parameters to be used in the API call
     * 
     * @return a {@link Map} containing the query parameters
     */
    public Map<String, String> getQueryParameters();
    
    /**
     * Byte array containing the entity content. 
     * May be {@code null} if the method does not support sending a request entity
     * 
     * @return byte array with the entity content or {@code null}
     */
    public byte[] getEntityContent();
    
    /**
     * Content type for the entity content.
     * May be {@code null} if the method does not support sending a request entity
     * 
     * @return a {@code String} containing the content type of the request entity or {@code null}
     */
    public String getEntityContentType();
}
