/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.servlets;

import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.ComponentContext;

import javax.servlet.ServletException;
import java.io.IOException;
import java.util.Dictionary;

@SlingServlet(paths = "/index", methods = "GET", metatype = true, label = "%rootmapping.name", description = "%rootmapping.desc")
public class RootMappingServlet extends SlingSafeMethodsServlet {

    @Property(value = "/content", description = "%rootmapping.target.desc")
    private static final String TARGET = "rootmapping.target";
    private static final long serialVersionUID = 3652955044323243271L;
    private String target;

    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.sendRedirect(request.getContextPath() + target);
    }

    // ----------------------------------------------< src integeration >-------
    protected void activate(ComponentContext context) {
        Dictionary properties = context.getProperties();
        target = (String) properties.get(TARGET);
        if (!target.startsWith("/")) {
            target = "/" + target;
        }
    }
}

