/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api;

import java.io.File;
import java.io.IOException;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.apache.sling.api.resource.ResourceResolver;

/**
 * The <code>DamManager</code> provides utility methods for DAM.
 * <p>
 * The DAM manager can be adapted (retrieved) via resource resolver:
 * <blockquote><pre>
 *    ...
 *    DamManager damManager = resourceResolver.adaptTo(DamManager.class);
 *    ...
 * </pre></blockquote>
 * @deprecated Use {@link com.day.cq.dam.commons.util.DamUtil} instead.
 */
//todo: remove class for CQ 5.5
@Deprecated
public interface DamManager {

    /**
     * This method works almost the same way as {@link File#createTempFile(String, String)} . The only difference is
     * that one can specify on the <code>DamManager</code> the temp dir location.
     *
     * @param prefix The prefix string to be used in generating the file's name; must be at least three characters long
     * @param suffix The suffix string to be used in generating the file's name; may be <code>null</code>, in which case
     *               the suffix <code>".tmp"</code> will be used
     * @return temp file
     * @throws IOException Thrown upon an error occurring during file handling.
     * @deprecated Use {@link java.io.File#createTempFile(String, String)} instead.
     */
    @Deprecated
    File createTempFile(String prefix, String suffix) throws IOException;

    /**
     * Creates the asset data path resp. replaces the /var/dam prefix with the /content/dam prefix
     *
     * @param binaryNodePath the binary file path (e.g. /var/dam/test.jpeg)
     * @return the path under /content/dam
     * @deprecated Use {@link com.day.cq.dam.commons.util.DamUtil#binaryToAssetPath(String)} instead.
     */
    @Deprecated
    String createMetadataPath(String binaryNodePath);

    /**
     * Creates the binary data path resp. replaces the /content/dam prefix with the /var/dam prefix
     *
     * @param assetNodePath the asset file path (e.g. /content/dam/test.jpeg)
     * @return the path under /var/dam
     * @deprecated Use {@link com.day.cq.dam.commons.util.DamUtil#assetToBinaryPath(String)} instead.
     */
    @Deprecated
    String createBinaryUploadLocationPath(String assetNodePath);

    /**
     * Creates a new administrative {@link javax.jcr.Session} on the workspace used by the <code>DamManager</code>.
     *
     * @return The administrative JCR session.
     * @throws RepositoryException Thrown upon encountering an error creating the session.
     * @deprecated Will be removed without replacement.
     */
    @Deprecated
    Session getSession() throws RepositoryException;

    /**
     * Retrieves the node given by the <code>assetNodePath</code> parameter or <code>null</code> if it doesn't exist.
     *
     * @param assetNodePath The node to retrieve.
     * @param session       The JCR session to work with.
     * @return The node.
     * @deprecated Use {@link com.day.cq.dam.commons.util.DamUtil#getAssetNodeForBinary(String, Session)} instead.
     */
    @Deprecated
    Node getAssetNode(String assetNodePath, Session session);

    /**
     * Removes the node of an asset.
     *
     * @param assetNodePath The path of the asset to remove.
     * @param session       The JCR session to work with.
     * @deprecated Use {@link com.day.cq.dam.commons.util.DamUtil#removeAssetForBinary(String, Session)} instead.
     */
    @Deprecated
    void removeAssetNode(String assetNodePath, Session session);

    /**
     * This method creates the complete asset structure in the asset content 'store'. (in our case /content/dam').
     * following structure is created: &lt;xmp&gt; + file.jpg (dam:Asset) + jcr:content )(dam:AssetContent) + renditions
     * (sling:Folder) + metadata (nt:unstructured)
     * <p>
     * &lt;xmp&gt;
     * <p>
     * The binary path points to the upload location (in our case /var/dam). the <code>/var/dam</code> prefix will be
     * replaced by <code>/content/dam</code>
     * <p>
     *
     * @param binaryPath path where the binary is put for upload (/var/dam/...)
     * @param session    jcr session used
     * @param doSave     <code>true</code> for immediate saves
     * @return Returns the {@link Asset}
     * @deprecated Use {@link com.day.cq.dam.commons.util.DamUtil#createAssetForBinary(String, ResourceResolver, Boolean)}
     *             instead.
     */
    @Deprecated
    Asset createAssetStructure(String binaryPath, Session session, boolean doSave);
}
