/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.commons.util;

/**
 * The <code>TenantConstants</code> interface defines tenant specific properties/constants
 */
public interface DamConfigurationConstants {

    /**
     * property for group id for all users of a specific tenant.
     * e.g. mac-geometrixx-all
     */
    static final String DAM_ALL_USERS_GROUP_ID = "dam:allUsersGroupId";
    
    /**
     * property for tenant specific repository path (mount point) for assets
     * e.g. /content/dam/mac/geometrixx
     */
    static final String DAM_ASSETS_ROOT = "dam:assetsRoot";
    
    /**
     * property for repository path of user home of tenants
     * e.g. /home/users/mac/geometrixx
     */
    static final String DAM_TENANT_USER_HOME = "dam:tenantUserHome";
    
    /**
     * property for repository path of collection home of tenants
     */
    static final String DAM_COLLECTION_HOME = "dam:collectionHome";

    /**
     * property for gql facets root path of tenant
     */
    static final String DAM_GQL_FACETS_ROOT = "dam:gqlFacetsHome";

    /**
     * property for repository path to keep data for preview of search facets
     * e.g. /var/geometrixx/dam/content/customsearch/facets/preview
     */
    static final String DAM_SEARCH_FACETS_PREVIEW_PATH = "dam:searchFacetsPreviewPath";


    /**
     * repository path to store marketing cloud related information like marketing cloud url
     */
    static final String MARKETING_CLOUD_REDIRECT_CONFIG = "/apps/marketingCloud";

    /**
     * relative path to Conf item for admin ui configurations
     */
    static final String ADMIN_UI_OOTB_CONF_RELPATH = "dam/adminui";

    /**
     * relative path to Conf item for extensions to admin ui
     */
    static final String ADMIN_UI_EXTENSION_CONF_RELPATH = "dam/adminui-extension";

    /**
     * conf properties representing paths for various admin application customization home
     */
    static final String METADATA_PROFILE_HOME = "metadataprofile.home";

    static final String IMAGE_PROFILE_HOME = "imageprofile.home";

    static final String METADATA_SCHEMA_HOME = "metadataschema.home";

    static final String FOLDER_METADATA_SCHEMA_HOME = "foldermetadataschema.home";

    /**
     * Default repository paths of various admin application customization
     */
    static final String DEFAULT_METADATA_PROFILE_HOME = "/conf/global/settings/dam/adminui-extension/metadataprofile";

    static final String DEFAULT_IMAGE_PROFILE_HOME = "/conf/global/settings/dam/adminui-extension/imageprofile";

    static final String DEFAULT_METADATA_SCHEMA_NAME = "metadataschema";

    static final String DEFAULT_METADATA_SCHEMA_HOME
            = "/conf/global/settings/dam/adminui-extension/" + DEFAULT_METADATA_SCHEMA_NAME;

    static final String DEFAULT_FOLDER_METADATA_SCHEMA_HOME = "/conf/global/settings/dam/adminui-extension/foldermetadataschema";

    /**
     * Default repository paths of various admin application configurations provided OOTB
     */

    static final String OOTB_METADATA_SCHEMA_FORM_HOME = "/libs/dam/content/schemaeditors/forms";

    static final String OOTB_FOLDER_METADATA_SCHEMA_FORM_HOME = "/libs/dam/content/schemaeditors/forms";

    /**
     * conf properties for DynamicMedia
     */
    static final String DYNAMICMEDIA                            = "dynamicmediaconfig";
    static final String UPLOAD_STATUS_POLL_INTERVAL_CONFIG   = "uploadStatusPollInterval";

    /**
    * Default repository path for NUI processing profiles
    */
   static final String DEFAULT_NUI_PROFILE_HOME = "/conf/global/settings/dam/processing";
}