/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.commons.xml;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import aQute.bnd.annotation.ProviderType;

/**
 * Interface to provide safe DocumentBuilderFactory instance which is susceptible to XXE/XEE attacks.
 * Following XML parsing related vulnerabilities were detected in SAXReader objects in apache POI.
 * http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2014-3574
 * http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2014-3529
 * 
 * This interface id for internal use only.
 */
@ProviderType
public interface SecureDocumentBuilderFactory {

    /**
     * Invoked when a new instance of DocumentBuilderFactory is required.
     * @param setNamespaceAware Whether to set NamespaceAware configuration for DocumentBuilderFactory to true or not.
     * @return A new instance of DocumentBuilderFactory.
     * @throws ParserConfigurationException If a DocumentBuilder cannot be created which satisfies the configuration requested.
     * 
     * Following configurations has been added
     * 
     * factory.setNamespaceAware(true);
     * factory.setValidating(true);
     * factory.setExpandEntityReferences(false);
     * factory.setFeature("http://xml.org/sax/features/validation", true);
     * 
     * // do not include external general entities
     * factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
 
     * // do not include external parameter entities or the external DTD subset
     * factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
 
     * // build the grammar but do not use the default attributes and attribute types information it contains
     * factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
 
     * // ignore the external DTD completely
     * factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
     */
    public DocumentBuilderFactory createSecureBuilderFactory(Boolean setNamespaceAware) throws ParserConfigurationException;
	
}
