/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.notification.api;

import org.osgi.service.event.Event;

/**
 * todo:
 * <p/>
 * Task 1) announce availability of event topic (accepts) Task 2) deliver UI event blueprint (SubscriptionInfo) (allows
 * generic event property filtering / matching / config) Task 3) provide implementation-specific filters
 */
public interface SubscriptionFilter {

    /**
     * Determines whether this subscription filter accepts the given <code>event</code>. If it doesn't, this provider
     * should not be used for subscription retrieval.
     *
     * @param event The {@link Event} to check.
     *
     * @return <code>true</code> if this provider accepts the event.
     */
     boolean accepts(Event event);

    /**
     * Determines whether the given <code>subscription</code> corresponds to the filter criteria of this handler.
     *
     * @param subscription The {@link Subscription} to check.
     *
     * @return <code>true</code> if the subscription corresponds to the filter criteria.
     */
    boolean accepts(Subscription subscription);

    /**
     * Returns the filter criteria.
     *
     * @return A {@link EventInfo} object.
     */
    EventInfo getInfo();
}
