/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.polling.importer;

import org.apache.sling.api.resource.Resource;

import aQute.bnd.annotation.ConsumerType;

@ConsumerType
public interface Importer {

    /**
     * Service name under which Importer services are to be registered (value is
     * "com.day.cq.polling.importer.Importer").
     */
    static final String SERVICE_NAME = "com.day.cq.polling.importer.Importer";

    /**
     * The name of the service property defining the scheme supported by the
     * importer (value is "importer.scheme").
     * <p>
     * This service property may a single string value or an array or collection
     * of String values. The service is registered for all schemes provided by
     * this property.
     * <p>
     * If this service property is missing, empty or not one of the listed
     * types, the service cannot be used and is therefore ignored.
     */
    static final String SCHEME_PROPERTY = "importer.scheme";

    /**
     * This method is called to poll for data to be imported at the given called
     * <code>dataSource</code> location and to import the result into the target
     * <code>Resource</code>.
     *
     * @param scheme The actual scheme of the data source. If an
     *            <code>Importer</code> is registered for multiple schemes, this
     *            scheme may for example be used to decide on which data
     *            represenation can be expected. This value is one of the
     *            schemes with which the <code>Importer</code> service has been
     *            configured in the {@link #SCHEME_PROPERTY importer.scheme
     *            service property}.
     * @param dataSource The scheme specific string (generally an URI)
     *            describing the location at which the data is to be polled. The
     *            format of this string is specific to the actual
     *            <code>scheme</code> used. For example, this may be a plain
     *            HTTP URL of the form <i>http://host/some/data.xml</i>.
     * @param target The target resource into which the data has to be imported
     * @throws ImportException may be thrown in case of problems accessing,
     *             transferring or actually importing the data. If the failure
     *             is caused by an exception, this exception (
     *             <code>Throwable</code>) should be made available as the cause
     *             of this exception.
     */
    void importData(String scheme, String dataSource, Resource target)
            throws ImportException;

    /**
     * This method is called to poll for data to be imported at the given called
     * <code>dataSource</code> location and to import the result into the target
     * <code>Resource</code>.
     *
     * @param scheme The actual scheme of the data source. If an
     *            <code>Importer</code> is registered for multiple schemes, this
     *            scheme may for example be used to decide on which data
     *            represenation can be expected. This value is one of the
     *            schemes with which the <code>Importer</code> service has been
     *            configured in the {@link #SCHEME_PROPERTY importer.scheme
     *            service property}.
     * @param dataSource The scheme specific string (generally an URI)
     *            describing the location at which the data is to be polled. The
     *            format of this string is specific to the actual
     *            <code>scheme</code> used. For example, this may be a plain
     *            HTTP URL of the form <i>http://host/some/data.xml</i>.
     * @param target The target resource into which the data has to be imported
     * @param login The login for basic authentication.
     * @param password The password for basic authentication.
     * @throws ImportException may be thrown in case of problems accessing,
     *             transferring or actually importing the data. If the failure
     *             is caused by an exception, this exception (
     *             <code>Throwable</code>) should be made available as the cause
     *             of this exception.
     */
    void importData(String scheme, String dataSource, Resource target, String login, String password)
    throws ImportException;

}
