/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

import java.util.HashMap;
import java.util.Map;

/**
 * Contains the information obtained from an {@link Agent} that supports
 * reverse replication.
 */
public class ReverseReplication {

    /**
     * Default name of the "outbox item path" attribute.
     */
    public static final String PROP_OUTBOX_ITEM_PATH = "outbox.item.path";

    /**
     * Replication content.
     */
    private ReplicationContent content;

    /**
     * Replication action.
     */
    private ReplicationAction action;

    /**
     * Optional properties
     */
    private Map<String, String> properties;

    /**
     * Create a new instance of this class.
     *
     * @param content
     *            replication content
     * @param action
     *            replication action
     */
    public ReverseReplication(ReplicationContent content,
                              ReplicationAction action) {

        this.content = content;
        this.action = action;
    }

    /**
     * Return the replication content.
     *
     * @return replication content
     */
    public ReplicationContent getContent() {
        return content;
    }

    /**
     * Return the replication action.
     *
     * @return replication action
     */
    public ReplicationAction getAction() {
        return action;
    }

    /**
     * Returns optional properties
     * @return optional properties.
     */
    public Map<String, String> getProperties() {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        return properties;
    }
}
