/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security.profile;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

import com.day.cq.security.Authorizable;

/**
 * Provide access to Profiles of {@link Authorizable Authorizables}.
 * A Profile may be associated with a given application.
 * @deprecated cq 5.5
 */
public interface ProfileManager {

    /**
     * @param authorizableId ID of the
     *        {@link com.day.cq.security.Authorizable Authorizable} to access
     *        the Profile for
     * @param session to use to access the
     *        {@link com.day.cq.security.profile.Profile Profile} with
     * @return Profile or <code>null</code> if none defined or accessible
     * @throws RepositoryException in case of error accessing the Repository
     */
    Profile getProfile(String authorizableId, Session session)
            throws RepositoryException;

    /**
     * @param authorizableId ID of the
     *        {@link com.day.cq.security.Authorizable Authorizable} to access
     *        the Profile for
     * @param session to use to access the
     *        {@link com.day.cq.security.profile.Profile Profile} with
     * @param appName identifier of the application the profile is dedicated to
     * @return Profile or <code>null</code> if none defined or accessible
     * @throws RepositoryException in case of error accessing the Repository
     */
    Profile getProfile(String authorizableId, Session session, String appName)
            throws RepositoryException;
}
