/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.tagging;

import javax.jcr.Node;
import javax.jcr.Session;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * <code>JcrTagManagerFactory</code> returns a JCR-based implementation of a
 * {@link TagManager}. This is the reference implementation of the tagging API.
 * 
 * <h3>Getting a JCR-based TagManager</h3>
 * First you need the service instance of this interface. Call
 * {@link #getTagManager(ResourceResolver)} on it with a JCR {@link ResourceResolver} to retrieve a
 * {@link TagManager} instance:
 * 
 * <pre><code>
 * Reference
 * JcrTagManagerFactory jcrTagManagerFactory;
 * 
 * ...
 * 
 * TagManager tagManager = jcrTagManagerFactory.getTagManager(session);
 * </code></pre>
 * 
 * In the typical Sling context you can also adapt to a {@link TagManager} from
 * the {@link ResourceResolver}:
 * 
 * <pre><code>
 * TagManager tagManager = resourceResolver.adaptTo(ResourceResolver.class);
 * </code></pre>
 * 
 * <h3>About the JCR implementation</h3>
 * The JCR-based TagManager instance is not a global singleton and does not
 * cache anything, because it is bound to a specific JCR {@link Session} and
 * maps all operations to {@linkplain Node Nodes}, queries and other JCR API
 * operations.
 * 
 * <p>
 * Tags are <b>stored in the repository under a base path</b>, 
 * which is provided by property <code>base.path</code> (it can be changed by setting the OSGI
 * property <code>base.path</code> for the implementation
 * <code>com.day.cq.tagging.impl.JcrTagManagerFactoryImpl</code>). Tag paths
 * are mapped to JCR paths directly (also see the absolute tag path description
 * in {@link Tag}). A tag node has the type <code>cq:Tag</code>. The
 * top-most level, ie. everything directly under the tag base path, represents
 * namespaces, everything below tags or container tags (if they have tag
 * children themselves). Namespaces and tags thus have both the same node type
 * <code>cq:Tag</code>. You are free to add other content to namespaces or
 * tags, the node type allows residual properties and any child nodes.
 * 
 * <p>
 * <b>Author tagging:</b> To tag content (ie. nodes in the repository), assign
 * the mixin <code>cq:OwnerTaggable</code> to the node. OwnerTaggable means
 * that the content-creator or author should be able to tag it for
 * organizational purposes. The mixin essentially defines one multi-value
 * property <code>cq:tags</code>, where each value is one tag that is either
 * a tag ID or an absolute path to the tag.
 * 
 * <p>
 * <b>User tagging</b>: Use the mixin <code>cq:UserTaggable</code> if any
 * user of the site should be able to add his own tags to the content.
 * <b>Important note: user-tagging is not yet implemented; it will store the
 * tags in the user's home directory, but access to this is not implemented and
 * the according node types are not final yet.</b>
 * 
 * <p>
 * The implementation allows to manage tags and tag content solely by using the
 * JCR API. It will ensure that tags set in the <code>cq:tags</code> property
 * are not duplicated and that the user that set them had the rights to use this
 * tag. This is done by using a JCR observation listener that will revert any
 * incorrect changes. The creation of tags (eg. denying users to create new tags
 * in a certain namespace) on the other hand must be restricted by setting
 * appropiate ACLs in the repository.
 * 
 * <p>
 * <b>Rights:</b> A typical setting would only allow a group/role
 * "tagadministrator" to modify namespaces (add/modify under
 * <code>{base.path}</code>), read access for all users/authors to all the
 * namespaces that should be readable to them (mostly all) and write access only
 * for those namespaces where tags should be freely definable by users/authors
 * (add_node under <code>{base.path}/some_namespace</code>).
 */
@ProviderType
public interface JcrTagManagerFactory {

    /**
     * @param session serviceSession
     * @deprecated This is deprecated in favor of {@link #getTagManager(ResourceResolver)}
     * @return Tagmanager
     * Using this method, might cause session leak in the system.
     *
     * Returns a JCR-based {@link TagManager} implementation.
     * 
     * This one is bound to a JCR session, either from a request (eg.
     * <code>resourceResolver.adaptTo(TagManager.class)</code>, in which case
     * you won't have to call this method directly) or by using a self-made
     * session, for example:
     * 
     * <pre><code>
     * Session serviceSession = repository.loginService(...);
     * TagManager tagManager = JcrTagManagerFactory.getTagManager(serviceSession);
     * </code></pre>
     * 
     * Please note that the visibility of tags and the right to create a tag
     * depend on the user of the session (access rights are simply mapped to
     * node read and creation rights of the repository), so an administrative
     * session like above could do more than a "normal" user. In most cases it
     * is advised to use the current request's session (= the request's user),
     * eg. by using:
     * 
     * <pre><code>
     * TagManager tagManager = resourceResolver.adaptTo(TagManager.class);
     * </code></pre>
     */
    @Deprecated
    TagManager getTagManager(Session session);

    /**
     * @param resolver serviceResolver
     * @return Tagmanager
     * Returns a JCR-based {@link TagManager} implementation.
     *
     * This one is bound to a Resource Resolver, either from a request (eg.
     * <code>resourceResolver.adaptTo(TagManager.class)</code>, in which case
     * you won't have to call this method directly) or by using a self-made
     * resolver, for example:
     *
     * <pre><code>
     * ResourceResolver serviceResolver = resourceResolverFactory.getServiceResourceResolver(...);
     * TagManager tagManager = JcrTagManagerFactory.getTagManager(serviceResolver);
     * </code></pre>
     *
     * Please note that the visibility of tags and the right to create a tag
     * depend on the user of the session (access rights are simply mapped to
     * node read and creation rights of the repository), so an administrative
     * user like above could do more than a "normal" user. In most cases it
     * is advised to use the current request's session (= the request's user),
     * eg. by using:
     *
     * <pre><code>
     * TagManager tagManager = resourceResolver.adaptTo(TagManager.class);
     * </code></pre>
     */
    TagManager getTagManager(ResourceResolver resolver);
}
